/**
* \file: AutoCompletion.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AutoCompletion.h"
#include "Common.h"

namespace adit { namespace carplay
{

PoolTemplate<AutoCompletion::_Reference, 64> AutoCompletion::pool;

AutoCompletion::AutoCompletion(void (*completion)(void* context), void* context)
{
    if (completion != nullptr)
    {
        reference = pool.Take();
        dipo_exit_on_null(reference);

        reference->completion = completion;
        reference->context = context;
    }
    else
        reference = nullptr;
}

AutoCompletion::~AutoCompletion()
{
    AutoCompletion::Completion(reference);
}

AutoCompletion::AutoCompletionContext AutoCompletion::GetAdditionalReference()
{
    if (reference != nullptr)
        reference->count++;
    return reference;
}

void AutoCompletion::Completion(AutoCompletionContext context)
{
    auto reference = static_cast<_Reference*>(context);

    if (reference != nullptr && reference->count > 0)
    {
        reference->count--;
        if (reference->count == 0 && reference->completion != nullptr)
        {
            reference->completion(context);
        }
    }
}


} } // namespace adit { namespace carplay
